<?php
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Conectar a la base de datos
require_once 'conexiones/conexion.php';
require_once 'solicitudes/email_usuario_conectado.php';

// Obtener la fecha actual
$hoy = date('Y-m-d');
$mes_actual = date('Y-m');
//email del usuario conectado para las consultas
 $email = $result['email'];
// Consultas para obtener los datos
try {
   // Tickets creados hoy por el usuario conectado
$stmt = $pdo->prepare("SELECT COUNT(*) AS tickets_hoy FROM tickets WHERE DATE(fecha_creacion) = ? AND usuario_venta = ?");
$stmt->execute([$hoy, $email]);
$tickets_hoy = $stmt->fetch(PDO::FETCH_ASSOC)['tickets_hoy'];


 // Tickets totales este mes por el usuario conectado
$stmt = $pdo->prepare("SELECT COUNT(*) AS tickets_totales FROM tickets WHERE DATE_FORMAT(fecha_creacion, '%Y-%m') = ? AND usuario_venta = ?");
$stmt->execute([$mes_actual, $email]);
$tickets_totales = $stmt->fetch(PDO::FETCH_ASSOC)['tickets_totales'];


   // Recaudado hoy por el usuario conectado
$stmt = $pdo->prepare("SELECT SUM(precio) AS recaudado_hoy FROM tickets WHERE DATE(fecha_creacion) = ? AND usuario_venta = ?");
$stmt->execute([$hoy, $email]);
$recaudado_hoy = $stmt->fetch(PDO::FETCH_ASSOC)['recaudado_hoy'] ?? 0;

    // Clientes registrados
    $stmt = $pdo->prepare("SELECT COUNT(*) AS clientes_registrados FROM clientes");
    $stmt->execute();
    $clientes_registrados = $stmt->fetch(PDO::FETCH_ASSOC)['clientes_registrados'];
} catch (PDOException $e) {
    die("Error en la consulta: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard de Tickets</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
 
</head>
<body>
    <?php include "menuajuste.php"; ?>
    <div class="content">
        <h1 class="text-center mb-4">Tu Dashboard de Tickets</h1>
        <div class="row g-4">
            <!-- Tickets creados hoy -->
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="icon-circle bg-gradient-primary mx-auto">
                            <i class="fas fa-ticket-alt text-white"></i>
                        </div>
                        <h5 class="card-title">Tickets de Hoy creados por usted.</h5>
                        <p class="card-text fs-4"><?= htmlspecialchars($tickets_hoy) ?></p>
                    </div>
                </div>
            </div>
            <!-- Total de Tickets -->
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="icon-circle bg-gradient-success mx-auto">
                            <i class="fas fa-list text-white"></i>
                        </div>
                        <h5 class="card-title">Tickets Totales del mes</h5>
                        <p class="card-text fs-4"><?= htmlspecialchars($tickets_totales) ?></p>
                    </div>
                </div>
            </div>
            <!-- Recaudado hoy -->
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="icon-circle bg-gradient-warning mx-auto">
                            <i class="fas fa-dollar-sign text-white"></i>
                        </div>
                        <h5 class="card-title">Recaudado Hoy por usted.</h5>
                        <p class="card-text fs-4">$<?= number_format($recaudado_hoy, 2) ?></p>
                    </div>
                </div>
            </div>
            <!-- Clientes registrados -->
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="icon-circle bg-gradient-danger mx-auto">
                            <i class="fas fa-users text-white"></i>
                        </div>
                        <h5 class="card-title">Clientes Registrados</h5>
                        <p class="card-text fs-4"><?= htmlspecialchars($clientes_registrados) ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gráfica de Tickets -->
        <div class="chart-container mt-5">
            <h3 class="text-center mb-4">Estadísticas de Tickets</h3>
            <canvas id="ticketsChart"></canvas>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Configuración del gráfico
        const ctx = document.getElementById('ticketsChart').getContext('2d');
        const ticketsChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado', 'Domingo'],
                datasets: [{
                    label: 'Tickets Creados',
                    data: [12, 19, 3, 5, 2, 3, 7], // Sustituye con datos dinámicos si es necesario
                    backgroundColor: 'rgba(0, 123, 255, 0.2)',
                    borderColor: 'rgba(0, 123, 255, 1)',
                    borderWidth: 2,
                    tension: 0.4,
                    fill: true,
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>
